/*
 * Decompiled with CFR 0.152.
 */
package com.ICM.coordenadasRutaAPI.services;

import com.ICM.coordenadasRutaAPI.models.EmpresasModel;
import com.ICM.coordenadasRutaAPI.repositories.EmpresasRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmpresasService {
    @Autowired
    private EmpresasRepository empresasRepository;

    public EmpresasModel authenticateCompany(EmpresasModel empresasModel) {
        String usuario = empresasModel.getUsuario();
        String password = empresasModel.getPassword();
        Optional empresa = this.empresasRepository.findByUsuarioAndPassword(usuario, password);
        return empresa.orElse(null);
    }

    public Optional<EmpresasModel> findCompanyByName(String nombre) {
        return this.empresasRepository.findByNombre(nombre);
    }

    public Optional<EmpresasModel> findCompanyByUser(String usuario) {
        return this.empresasRepository.findByUsuario(usuario);
    }

    public List<EmpresasModel> getAllCompanies() {
        return this.empresasRepository.findAll();
    }

    public Optional<EmpresasModel> getCompanyById(Long id) {
        return this.empresasRepository.findById((Object)id);
    }

    public EmpresasModel saveCompany(EmpresasModel empresasModel) {
        return (EmpresasModel)this.empresasRepository.save((Object)empresasModel);
    }

    public EmpresasModel editCompany(Long id, EmpresasModel empresasModel) {
        Optional existing = this.empresasRepository.findById((Object)id);
        if (existing.isPresent()) {
            EmpresasModel empresa = (EmpresasModel)existing.get();
            empresa.setNombre(empresasModel.getNombre());
            return (EmpresasModel)this.empresasRepository.save((Object)empresa);
        }
        return null;
    }

    public void deleteCompany(Long id) {
        this.empresasRepository.deleteById((Object)id);
    }
}

