/*
 * Decompiled with CFR 0.152.
 */
package com.ICM.coordenadasRutaAPI.services;

import com.ICM.coordenadasRutaAPI.models.DispositivosModel;
import com.ICM.coordenadasRutaAPI.repositories.DispositivosRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class DispositivosService {
    @Autowired
    private DispositivosRepository dispositivosRepository;

    public List<DispositivosModel> getAllDispositivos() {
        return this.dispositivosRepository.findAll();
    }

    public Optional<DispositivosModel> getDispositivoById(Long id) {
        return this.dispositivosRepository.findById((Object)id);
    }

    public Optional<DispositivosModel> findByNombreAndEmpresasModelId(String nombre, Long empresaModelId) {
        return this.dispositivosRepository.findByNombreAndEmpresasModelId(nombre, empresaModelId);
    }

    public Page<DispositivosModel> findByEmpresaIdAndEstado(Long empresa, Boolean estado, int page, int size) {
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        return this.dispositivosRepository.findByEmpresasModelIdAndEstado(empresa, estado, (Pageable)pageable);
    }

    public DispositivosModel saveDispositivo(DispositivosModel dispositivosModel) {
        return (DispositivosModel)this.dispositivosRepository.save((Object)dispositivosModel);
    }

    public DispositivosModel actualizarDispositivo(Long id, DispositivosModel dispositivosModel) {
        Optional existing = this.dispositivosRepository.findById((Object)id);
        if (existing.isPresent()) {
            DispositivosModel dispositivo = (DispositivosModel)existing.get();
            dispositivo.setNombre(dispositivosModel.getNombre());
            dispositivo.setRutasModel(dispositivosModel.getRutasModel());
            dispositivo.setEmpresasModel(dispositivosModel.getEmpresasModel());
            return (DispositivosModel)this.dispositivosRepository.save((Object)dispositivo);
        }
        return null;
    }

    public DispositivosModel actualizarDispositivoprop(Long id, DispositivosModel dispositivosModel) {
        Optional existing = this.dispositivosRepository.findById((Object)id);
        if (existing.isPresent()) {
            DispositivosModel dispositivo = (DispositivosModel)existing.get();
            dispositivo.setRutasModel(dispositivosModel.getRutasModel());
            dispositivo.setVelocidad(dispositivosModel.getVelocidad());
            dispositivo.setVolumen(dispositivosModel.getVolumen());
            return (DispositivosModel)this.dispositivosRepository.save((Object)dispositivo);
        }
        return null;
    }

    public String props(Long id) {
        Optional existing = this.dispositivosRepository.findById((Object)id);
        if (existing.isPresent()) {
            DispositivosModel dispositivo = (DispositivosModel)existing.get();
            return dispositivo.getVolumen() + "\n" + dispositivo.getVelocidad();
        }
        return null;
    }

    public DispositivosModel reasignarRuta(Long id, DispositivosModel dispositivosModel) {
        Optional existing = this.dispositivosRepository.findById((Object)id);
        if (existing.isPresent()) {
            DispositivosModel dispositivo = (DispositivosModel)existing.get();
            dispositivo.setRutasModel(dispositivosModel.getRutasModel());
            dispositivo.setEmpresasModel(dispositivosModel.getEmpresasModel());
            return (DispositivosModel)this.dispositivosRepository.save((Object)dispositivo);
        }
        return null;
    }

    public void deleteDispositivoById(Long id) {
        this.dispositivosRepository.deleteById((Object)id);
    }
}

