/*
 * Decompiled with CFR 0.152.
 */
package com.ICM.coordenadasRutaAPI.controllers;

import com.ICM.coordenadasRutaAPI.models.PaisesModel;
import com.ICM.coordenadasRutaAPI.services.PaisesService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/paises"})
public class PaisesController {
    @Autowired
    PaisesService paisesService;

    @GetMapping
    public List<PaisesModel> getAllCountries() {
        return this.paisesService.getAllCountries();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<PaisesModel> getCountryById(@PathVariable Long id) {
        Optional paises = this.paisesService.getCountryById(id);
        return new ResponseEntity((Object)((PaisesModel)paises.get()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping
    public ResponseEntity<PaisesModel> saveCountry(@RequestBody PaisesModel paisesModel) {
        PaisesModel cpais = this.paisesService.saveCountry(paisesModel);
        return new ResponseEntity((Object)cpais, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<PaisesModel> updateCountry(@PathVariable Long id, @RequestBody PaisesModel paisesModel) {
        PaisesModel epais = this.paisesService.updateCountry(id, paisesModel);
        if (epais != null) {
            return new ResponseEntity((Object)epais, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<PaisesModel> deleteCountry(@PathVariable Long id) {
        this.paisesService.deleteCountry(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }
}

