/*
 * Decompiled with CFR 0.152.
 */
package com.ICM.coordenadasRutaAPI.controllers;

import com.ICM.coordenadasRutaAPI.models.EmpresasModel;
import com.ICM.coordenadasRutaAPI.services.EmpresasService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/empresas"})
public class EmpresasController {
    @Autowired
    private EmpresasService empresasService;

    @PostMapping(value={"/login"})
    public ResponseEntity<EmpresasModel> authenticateCompany(@RequestBody EmpresasModel empresasModel) {
        EmpresasModel login = this.empresasService.authenticateCompany(empresasModel);
        if (login != null) {
            return new ResponseEntity((Object)login, (HttpStatusCode)HttpStatus.CREATED);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/findNombre/{nombre}"})
    public ResponseEntity<String> findCompanyByName(@PathVariable String nombre) {
        Optional data = this.empresasService.findCompanyByName(nombre);
        return data.map(response -> ResponseEntity.ok((Object)"Ya est\u00e1 en uso ese nombre")).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/findUsuario/{usuario}"})
    public ResponseEntity<String> FindByUsuario(@PathVariable String usuario) {
        Optional data = this.empresasService.findCompanyByUser(usuario);
        return data.map(response -> ResponseEntity.ok((Object)"El usuario ya se encuentra en uso")).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping
    public List<EmpresasModel> getAllCompanies() {
        return this.empresasService.getAllCompanies();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<EmpresasModel> getCompanyById(@PathVariable Long id) {
        Optional data = this.empresasService.getCompanyById(id);
        return data.map(response -> ResponseEntity.ok((Object)response)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public ResponseEntity<EmpresasModel> saveCompany(@RequestBody EmpresasModel empresasModel) {
        EmpresasModel cempresa = this.empresasService.saveCompany(empresasModel);
        return new ResponseEntity((Object)cempresa, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<EmpresasModel> editCompany(@PathVariable Long id, @RequestBody EmpresasModel empresasModel) {
        EmpresasModel eempresa = this.empresasService.editCompany(id, empresasModel);
        if (eempresa != null) {
            return new ResponseEntity((Object)eempresa, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<EmpresasModel> deleteCompany(@PathVariable Long id) {
        this.empresasService.deleteCompany(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }
}

