/*
 * Decompiled with CFR 0.152.
 */
package com.ICM.coordenadasRutaAPI.controllers;

import com.ICM.coordenadasRutaAPI.RequestData.CoordenadasDTOtxt;
import com.ICM.coordenadasRutaAPI.models.CoordenadasModel;
import com.ICM.coordenadasRutaAPI.services.CoordenadasService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/coordenadas"})
public class CoordenadasController {
    @Autowired
    CoordenadasService coordenadasService;

    @GetMapping(value={"/ruta/{ruta}"})
    public List<CoordenadasModel> GetxCoordenadas(@PathVariable Long ruta) {
        return this.coordenadasService.GetxRutas(ruta);
    }

    @GetMapping(value={"/conteoPaginas/{id}"})
    public Long countPages(@PathVariable Long id) {
        return this.coordenadasService.countPages(id);
    }

    @GetMapping(value={"/cxr/{ruta}"})
    public Page<CoordenadasModel> obtenerCoordenadasPaginadas(@PathVariable Long ruta, @RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="6") int pageSize) {
        return this.coordenadasService.GetxRutasP(ruta, pageNumber, pageSize);
    }

    @GetMapping(value={"/cxrp/{ruta}"})
    public Page<CoordenadasDTOtxt> obtenerCoordenadasPaginadastxt(@PathVariable Long ruta, @RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="4") int pageSize) {
        return this.coordenadasService.GetxRutasPtxt(ruta, pageNumber, pageSize);
    }

    @GetMapping(value={"/cxrp/{dispositivo}/download"})
    public ResponseEntity<Object> descargarCoordenadasTxt(@PathVariable Long dispositivo, @RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="4") int pageSize) {
        Page coordenadasPage = this.coordenadasService.GetxRutasPtxt(dispositivo, pageNumber, pageSize);
        String contenidoTxt = this.convertirCoordenadasAString(coordenadasPage);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(contenidoTxt.getBytes(StandardCharsets.UTF_8));
        InputStreamResource inputStreamResource = new InputStreamResource((InputStream)inputStream);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment; filename=coordenadas.txt");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentType(MediaType.parseMediaType((String)"text/plain")).body((Object)inputStreamResource);
    }

    private String convertirCoordenadasAString(Page<CoordenadasDTOtxt> coordenadasPage) {
        StringBuilder stringBuilder = new StringBuilder();
        coordenadasPage.forEach(coordenada -> {
            stringBuilder.append(coordenada.getCoordenadas()).append(", ");
            stringBuilder.append(coordenada.getRdo()).append(", ");
            stringBuilder.append(coordenada.getNsv()).append(", ");
            stringBuilder.append(coordenada.getCodv()).append(", ");
            stringBuilder.append(coordenada.getCods()).append("\n");
        });
        return stringBuilder.toString();
    }

    @GetMapping
    public List<CoordenadasModel> GetAll() {
        return this.coordenadasService.Get();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<CoordenadasModel> GetById(@PathVariable Long id) {
        Optional paises = this.coordenadasService.GetById(id);
        return new ResponseEntity((Object)((CoordenadasModel)paises.get()), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping
    public ResponseEntity<CoordenadasModel> Save(@RequestBody CoordenadasModel coordenadasModel) {
        CoordenadasModel ccoordenadas = this.coordenadasService.Save(coordenadasModel);
        return new ResponseEntity((Object)ccoordenadas, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<CoordenadasModel> Edit(@PathVariable Long id, @RequestBody CoordenadasModel coordenadasModel) {
        CoordenadasModel ecoordenada = this.coordenadasService.Edit(id, coordenadasModel);
        if (ecoordenada != null) {
            return new ResponseEntity((Object)ecoordenada, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<CoordenadasModel> Delete(@PathVariable Long id) {
        this.coordenadasService.Delete(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }
}

