/*
 * Decompiled with CFR 0.152.
 */
package com.ICM.coordenadasRutaAPI.services;

import com.ICM.coordenadasRutaAPI.models.CoordenadasModel;
import com.ICM.coordenadasRutaAPI.models.RutasModel;
import com.ICM.coordenadasRutaAPI.repositories.CoordenadasRepository;
import com.ICM.coordenadasRutaAPI.repositories.RutasRepository;
import jakarta.transaction.Transactional;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class RutasService {
    @Autowired
    RutasRepository rutasRepository;
    @Autowired
    CoordenadasRepository coordenadasRepository;

    public List<RutasModel> getRoutesByCompanyAndState(Long empresaId, Boolean estado) {
        return this.rutasRepository.findByEmpresasModelIdAndEstado(empresaId, estado);
    }

    public Page<RutasModel> getPagedRoutesByCompanyAndState(Long empresaId, Boolean estado, int pageNumber, int defaultPageSize) {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)defaultPageSize);
        Page<RutasModel> coordenadasPage = this.rutasRepository.findByEmpresasModelIdAndEstado(empresaId, estado, (Pageable)pageRequest);
        return coordenadasPage;
    }

    public List<RutasModel> getAllRoutes() {
        return this.rutasRepository.findAll();
    }

    public Optional<RutasModel> findRouteById(Long id) {
        return this.rutasRepository.findById(id);
    }

    public RutasModel saveNewRoute(RutasModel rutasModel) {
        return (RutasModel)this.rutasRepository.save(rutasModel);
    }

    public RutasModel updateExistingRouteById(Long id, RutasModel rutasModel) {
        Optional existing = this.rutasRepository.findById(id);
        if (existing.isPresent()) {
            RutasModel ruta = (RutasModel)existing.get();
            ruta.setNomruta(rutasModel.getNomruta());
            ruta.setEmpresasModel(rutasModel.getEmpresasModel());
            ruta.setPaisesModel(rutasModel.getPaisesModel());
            return (RutasModel)this.rutasRepository.save(ruta);
        }
        return null;
    }

    public RutasModel updateRouteStateById(Long id, boolean habilitar) {
        Optional existing = this.rutasRepository.findById(id);
        if (existing.isPresent()) {
            RutasModel ruta = (RutasModel)existing.get();
            ruta.setEstado(habilitar);
            if (habilitar) {
                ruta.setDiadeshabilitacion(null);
                ruta.setDiaeliminacion(null);
            } else {
                LocalDate fechaDeshabilitacion = LocalDate.now();
                ruta.setDiadeshabilitacion(fechaDeshabilitacion);
                LocalDate fechaEliminacion = fechaDeshabilitacion.plus(7L, ChronoUnit.DAYS);
                ruta.setDiaeliminacion(fechaEliminacion);
            }
            return (RutasModel)this.rutasRepository.save(ruta);
        }
        throw new RutaNoEncontradaException("La ruta con ID " + id + " no fue encontrada.");
    }

    @Transactional
    public void deleteRouteByIdAndAssociatedCoordinates(Long id) {
        List<CoordenadasModel> coordenadas = this.coordenadasRepository.findByRutasModelId(id);
        for (CoordenadasModel coordenada : coordenadas) {
            this.coordenadasRepository.delete(coordenada);
        }
        this.rutasRepository.deleteById(id);
    }

    public class RutaNoEncontradaException
    extends RuntimeException {
        public RutaNoEncontradaException(String mensaje) {
            super(mensaje);
        }
    }
}

