/*
 * Decompiled with CFR 0.152.
 */
package com.ICM.coordenadasRutaAPI.services;

import com.ICM.coordenadasRutaAPI.RequestData.CoordenadasDTOtxt;
import com.ICM.coordenadasRutaAPI.models.CoordenadasModel;
import com.ICM.coordenadasRutaAPI.models.DispositivosModel;
import com.ICM.coordenadasRutaAPI.models.RutasModel;
import com.ICM.coordenadasRutaAPI.repositories.CoordenadasRepository;
import com.ICM.coordenadasRutaAPI.repositories.DispositivosRepository;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class CoordenadasService {
    @Autowired
    private CoordenadasRepository coordenadasRepository;
    @Autowired
    private DispositivosRepository dispositivosRepository;

    public List<CoordenadasModel> GetxRutas(Long ruta) {
        RutasModel rutasModel = new RutasModel();
        rutasModel.setId(ruta);
        return this.coordenadasRepository.findByRutasModel(rutasModel);
    }

    public Page<CoordenadasDTOtxt> GetxRutasPtxt(Long dispositivo, int pageNumber, int defaultPageSize) {
        PageRequest pageRequest = PageRequest.of((int)(pageNumber - 1), (int)defaultPageSize);
        return this.dispositivosRepository.findById(dispositivo).map(DispositivosModel::getRutasModel).map(rutasModel -> this.coordenadasRepository.findByRutasModelId(rutasModel.getId(), (Pageable)pageRequest)).map(coordenadasPage -> coordenadasPage.map(coordenadaModel -> {
            CoordenadasDTOtxt coordenadasDTOtxt = new CoordenadasDTOtxt();
            coordenadasDTOtxt.setCoordenadas(coordenadaModel.getCoordenadas());
            coordenadasDTOtxt.setRdo(coordenadaModel.getRadio());
            coordenadasDTOtxt.setNsv(coordenadaModel.getSonidosVelocidadModel().getNombre());
            coordenadasDTOtxt.setCodv(coordenadaModel.getSonidosVelocidadModel().getCodvel());
            coordenadasDTOtxt.setCods(coordenadaModel.getSonidosGeocercaModel().getCodsonido());
            return coordenadasDTOtxt;
        })).orElse(Page.empty());
    }

    public Long countPages(Long dispositivo) {
        PageRequest pageRequest = PageRequest.of((int)1, (int)4);
        return this.dispositivosRepository.findById(dispositivo).map(DispositivosModel::getRutasModel).map(rutasModel -> this.coordenadasRepository.findByRutasModelId(rutasModel.getId(), (Pageable)pageRequest)).map(coordenadasPage -> coordenadasPage.getTotalPages()).orElse(0L);
    }

    public Page<CoordenadasModel> GetxRutasP(Long ruta, int pageNumber, int defaultPageSize) {
        RutasModel rutasModel = new RutasModel();
        rutasModel.setId(ruta);
        Long totalElements = this.coordenadasRepository.countByRutasModelId(ruta);
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)defaultPageSize);
        if (totalElements <= (long)defaultPageSize) {
            return new PageImpl(this.coordenadasRepository.findByRutasModelId(ruta));
        }
        return this.coordenadasRepository.findByRutasModelId(ruta, (Pageable)pageRequest);
    }

    public List<CoordenadasModel> Get() {
        return this.coordenadasRepository.findAll();
    }

    public Optional<CoordenadasModel> GetById(Long id) {
        return this.coordenadasRepository.findById(id);
    }

    private String formatearCoordenadas(String coordenadas) {
        String[] coordenadasArray = coordenadas.split(", ");
        String latitud = coordenadasArray[0].replace(',', '.');
        String longitud = coordenadasArray[1].replace(',', '.');
        latitud = String.format(Locale.US, "%.7f", Double.parseDouble(latitud));
        longitud = String.format(Locale.US, "%.7f", Double.parseDouble(longitud));
        return latitud + ", " + longitud;
    }

    public CoordenadasModel Save(CoordenadasModel coordenadasModel) {
        String coordenadaFormateada = this.formatearCoordenadas(coordenadasModel.getCoordenadas());
        coordenadasModel.setCoordenadas(coordenadaFormateada);
        return (CoordenadasModel)this.coordenadasRepository.save(coordenadasModel);
    }

    public CoordenadasModel Edit(Long id, CoordenadasModel coordenadasModel) {
        Optional existing = this.coordenadasRepository.findById(id);
        if (existing.isPresent()) {
            CoordenadasModel coordenadas = (CoordenadasModel)existing.get();
            String coordenadaFormateada = this.formatearCoordenadas(coordenadasModel.getCoordenadas());
            coordenadas.setCoordenadas(coordenadaFormateada);
            coordenadas.setRadio(coordenadasModel.getRadio());
            coordenadas.setSonidosVelocidadModel(coordenadasModel.getSonidosVelocidadModel());
            coordenadas.setSonidosGeocercaModel(coordenadasModel.getSonidosGeocercaModel());
            coordenadas.setSonidosGeocercaModel(coordenadasModel.getSonidosGeocercaModel());
            coordenadas.setRutasModel(coordenadasModel.getRutasModel());
            return (CoordenadasModel)this.coordenadasRepository.save(coordenadas);
        }
        return null;
    }

    public void Delete(Long id) {
        this.coordenadasRepository.deleteById(id);
    }
}

