/*
 * Decompiled with CFR 0.152.
 */
package com.ICM.coordenadasRutaAPI.controllers;

import com.ICM.coordenadasRutaAPI.models.SonidosGeocercaModel;
import com.ICM.coordenadasRutaAPI.services.SonidosGeocercaService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/SonidoGeo"})
public class SonidoGeocercaController {
    @Autowired
    public SonidosGeocercaService sonidosGeocercaService;

    @GetMapping
    public ResponseEntity<List<SonidosGeocercaModel>> GetAll() {
        List<SonidosGeocercaModel> data = this.sonidosGeocercaService.GetAll();
        if (data.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok(data);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<SonidosGeocercaModel> GetById(@PathVariable Long id) {
        Optional<SonidosGeocercaModel> sonidosG = this.sonidosGeocercaService.GetById(id);
        return sonidosG.map(data -> new ResponseEntity(data, (HttpStatusCode)HttpStatus.OK)).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @GetMapping(value={"/xpais/{countryId}"})
    public ResponseEntity<List<SonidosGeocercaModel>> Getxpais(@PathVariable Long countryId) {
        if (countryId == null || countryId <= 0L) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        List<SonidosGeocercaModel> data = this.sonidosGeocercaService.GetxPais(countryId);
        if (data.isEmpty()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(data, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/xtipoS/{tipoS}"})
    public ResponseEntity<List<SonidosGeocercaModel>> Getxtip\u00ecS(@PathVariable Long tipoS) {
        if (tipoS == null || tipoS <= 0L) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        List<SonidosGeocercaModel> data = this.sonidosGeocercaService.GetxTipos(tipoS);
        if (data.isEmpty()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(data, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/xpaisxtipo/{pais}/{tipo}"})
    public ResponseEntity<List<SonidosGeocercaModel>> GetxPais(@PathVariable Long pais, @PathVariable Long tipo) {
        if (pais == null || tipo == null || pais <= 0L || tipo <= 0L) {
            return ResponseEntity.badRequest().build();
        }
        List<SonidosGeocercaModel> data = this.sonidosGeocercaService.GetxPaisxTipoS(pais, tipo);
        if (data.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok(data);
    }
}

