/*
 * Decompiled with CFR 0.152.
 */
package com.ICM.coordenadasRutaAPI.controllers;

import com.ICM.coordenadasRutaAPI.models.RutasModel;
import com.ICM.coordenadasRutaAPI.services.RutasService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/rutas"})
public class RutasController {
    @Autowired
    RutasService rutasService;

    @GetMapping(value={"/xempresa"})
    public ResponseEntity<List<RutasModel>> getRoutesByCompanyAndState(@RequestParam Long empresaId, @RequestParam Boolean estado) {
        List<RutasModel> data = this.rutasService.getRoutesByCompanyAndState(empresaId, estado);
        if (data.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok(data);
    }

    @GetMapping(value={"/xempresaP/{estado}/{empresaId}"})
    public ResponseEntity<Object> getPagedRoutesByCompanyAndState(@PathVariable Long empresaId, @PathVariable Boolean estado, @RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="6") int pageSize) {
        Page<RutasModel> data = this.rutasService.getPagedRoutesByCompanyAndState(empresaId, estado, pageNumber, pageSize);
        if (data != null && !data.isEmpty()) {
            return ResponseEntity.ok(data);
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).body((Object)"No se encontraron datos");
    }

    @GetMapping
    public ResponseEntity<List<RutasModel>> getAllRoutes() {
        List<RutasModel> data = this.rutasService.getAllRoutes();
        if (data.isEmpty()) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.ok(data);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<RutasModel> getRouteById(@PathVariable Long id) {
        Optional<RutasModel> data = this.rutasService.findRouteById(id);
        return data.map(response -> ResponseEntity.ok((Object)response)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public ResponseEntity<RutasModel> createNewRoute(@RequestBody RutasModel routeModel) {
        RutasModel createdRoute = this.rutasService.saveNewRoute(routeModel);
        return new ResponseEntity((Object)createdRoute, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<RutasModel> updateRouteById(@PathVariable Long id, @RequestBody RutasModel rutasModel) {
        RutasModel data = this.rutasService.updateExistingRouteById(id, rutasModel);
        if (data != null) {
            return new ResponseEntity((Object)data, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PutMapping(value={"/estado/{id}/{habilitar}"})
    public ResponseEntity<?> updateRouteState(@PathVariable Long id, @PathVariable boolean habilitar) {
        try {
            RutasModel eruta = this.rutasService.updateRouteStateById(id, habilitar);
            return new ResponseEntity((Object)eruta, (HttpStatusCode)HttpStatus.OK);
        }
        catch (RutasService.RutaNoEncontradaException e) {
            return new ResponseEntity((Object)("Ruta no encontrada: " + e.getMessage()), (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)"Ocurri\u00f3 un error al cambiar el estado de la ruta.", (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<RutasModel> deleteRouteAndAssociatedCoordinatesById(@PathVariable Long id) {
        this.rutasService.deleteRouteByIdAndAssociatedCoordinates(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }
}

