/*
 * Decompiled with CFR 0.152.
 */
package com.ICM.coordenadasRutaAPI.controllers;

import com.ICM.coordenadasRutaAPI.models.RolesModel;
import com.ICM.coordenadasRutaAPI.services.RolesService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/roles"})
public class RolesController {
    @Autowired
    private RolesService rolesService;

    @GetMapping
    public List<RolesModel> getAllRoles() {
        return this.rolesService.getAllRoles();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<RolesModel> getRoleById(@PathVariable Long id) {
        Optional<RolesModel> rol = this.rolesService.getRoleById(id);
        if (rol.isPresent()) {
            return new ResponseEntity((Object)rol.get(), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PostMapping
    public ResponseEntity<RolesModel> createRole(RolesModel rolesModel) {
        RolesModel crol = this.rolesService.createRole(rolesModel);
        return new ResponseEntity((Object)crol, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<RolesModel> updateRole(@RequestBody RolesModel rolesModel, @PathVariable Long id) {
        RolesModel erol = this.rolesService.updateRole(rolesModel, id);
        if (erol != null) {
            return new ResponseEntity((Object)erol, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<RolesModel> deleteRole(@PathVariable Long id) {
        this.rolesService.deleteRole(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }
}

