/*
 * Decompiled with CFR 0.152.
 */
package com.ICM.coordenadasRutaAPI.controllers;

import java.net.MalformedURLException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/files"})
public class FilesController {
    @Value(value="${file.image}")
    private String pathimg;
    @Value(value="${file.audio}")
    private String pathadc;
    @Value(value="${file.bin}")
    private String bindir;

    @GetMapping(value={"/images/{filename:.+}"})
    public ResponseEntity<Resource> serveImage(@PathVariable String filename) {
        try {
            Path file = Paths.get(this.pathimg, new String[0]).resolve(filename);
            UrlResource resource = new UrlResource(file.toUri());
            if (resource.exists() || resource.isReadable()) {
                return ResponseEntity.ok().contentType(MediaType.IMAGE_PNG).body((Object)resource);
            }
            throw new RuntimeException("No se pudo leer el archivo!");
        }
        catch (Exception e) {
            throw new RuntimeException("Error: " + e.getMessage());
        }
    }

    @GetMapping(value={"/audios/{filename:.+}"})
    public ResponseEntity<Resource> serveAudio(@PathVariable String filename) {
        try {
            Path file = Paths.get(this.pathadc, new String[0]).resolve(filename);
            UrlResource resource = new UrlResource(file.toUri());
            if (resource.exists() || resource.isReadable()) {
                return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"audio/mpeg")).body((Object)resource);
            }
            throw new RuntimeException("No se pudo leer el archivo de audio!");
        }
        catch (Exception e) {
            throw new RuntimeException("Error: " + e.getMessage());
        }
    }

    @GetMapping(value={"/bin/{binaryFilename}"})
    public ResponseEntity<Resource> downloadBinaryFile(@PathVariable String binaryFilename) {
        Path bindirPath = Paths.get(this.bindir, new String[0]).toAbsolutePath().normalize();
        Path filePath = bindirPath.resolve(binaryFilename).normalize();
        if (!filePath.startsWith(bindirPath)) {
            return ResponseEntity.badRequest().build();
        }
        try {
            UrlResource file = new UrlResource(filePath.toUri());
            if (file.exists() || file.isReadable()) {
                String filename = filePath.getFileName().toString();
                HttpHeaders headers = new HttpHeaders();
                headers.add("Content-Disposition", "attachment; filename=\"" + filename + "\"");
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)file);
            }
            return ResponseEntity.notFound().build();
        }
        catch (MalformedURLException e) {
            return ResponseEntity.badRequest().body(null);
        }
    }
}

