/*
 * Decompiled with CFR 0.152.
 */
package com.ICM.coordenadasRutaAPI.controllers;

import com.ICM.coordenadasRutaAPI.models.DispositivosModel;
import com.ICM.coordenadasRutaAPI.services.DispositivosService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/dispositivos"})
public class DispositivosController {
    @Autowired
    DispositivosService dispositivosService;

    @GetMapping
    public List<DispositivosModel> getAllDispositivos() {
        return this.dispositivosService.getAllDispositivos();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<DispositivosModel> getDispositivoById(@PathVariable Long id) {
        Optional<DispositivosModel> dispositivos = this.dispositivosService.getDispositivoById(id);
        return new ResponseEntity((Object)dispositivos.get(), (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/verificar/{nombre}/{empresa}"})
    public ResponseEntity<DispositivosModel> getDispositivoByNombreAndEmpresa(@PathVariable String nombre, @PathVariable Long empresa) {
        Optional<DispositivosModel> dispositivo = this.dispositivosService.findByNombreAndEmpresasModelId(nombre, empresa);
        if (dispositivo.isPresent()) {
            return new ResponseEntity((Object)dispositivo.get(), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/empresax"})
    public ResponseEntity<Page<DispositivosModel>> findByEmpresaAndEstado(@RequestParam(name="empresaId") Long empresaId, @RequestParam(name="estado") Boolean estado, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="10") int size) {
        Page<DispositivosModel> dispositivos = this.dispositivosService.findByEmpresaIdAndEstado(empresaId, estado, page, size);
        return new ResponseEntity(dispositivos, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping
    public ResponseEntity<DispositivosModel> saveDispositivo(@RequestBody DispositivosModel dispositivosModel) {
        DispositivosModel cdispositivos = this.dispositivosService.saveDispositivo(dispositivosModel);
        return new ResponseEntity((Object)cdispositivos, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<DispositivosModel> actualizarDispositivo(@PathVariable Long id, @RequestBody DispositivosModel dispositivosModel) {
        DispositivosModel edispositivos = this.dispositivosService.actualizarDispositivo(id, dispositivosModel);
        if (edispositivos != null) {
            return new ResponseEntity((Object)edispositivos, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @PutMapping(value={"/prop/{id}"})
    public ResponseEntity<DispositivosModel> actualizarDispositivoprop(@PathVariable Long id, @RequestBody DispositivosModel dispositivosModel) {
        DispositivosModel edispositivos = this.dispositivosService.actualizarDispositivoprop(id, dispositivosModel);
        if (edispositivos != null) {
            return new ResponseEntity((Object)edispositivos, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/props/{id}"})
    public String getProps(@PathVariable Long id) {
        String propsString = this.dispositivosService.props(id);
        if (propsString != null) {
            return propsString;
        }
        return "Dispositivo no encontrado";
    }

    @PutMapping(value={"/reasignar/{id}"})
    public ResponseEntity<DispositivosModel> reasignarRuta(@PathVariable Long id, @RequestBody DispositivosModel dispositivosModel) {
        DispositivosModel edispositivos = this.dispositivosService.reasignarRuta(id, dispositivosModel);
        if (edispositivos != null) {
            return new ResponseEntity((Object)edispositivos, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<DispositivosModel> deleteDispositivo(@PathVariable Long id) {
        this.dispositivosService.deleteDispositivoById(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }
}

